import React from 'react';
import WithoutSorttableHeader from '../../../Componets/TableComponets/WithoutSorttableHeader';
import { UseGetVendordetail } from '../../../Appstore/Api/UseGetVendordetail';
import AvatarWithSpinner from '../../../Componets/LoadingComponest';
import notfound from "../../../assets/Images/notfound.png";
import TableUserInfo from '../../../Componets/TableComponets/TableUserInfo';
import SimpletextTableBodyReview from '../../../Componets/TableComponets/SimpletextTableBodyReview';
import TableDateTimeDisplay from '../../../Componets/TableComponets/TableDateTimeDisplay';

function ReviewsViewVendor() {
  const { data, isLoading } = UseGetVendordetail();

  console.log("Review list API response:", data?.reviews);

  return (
    <div className="w-full p-4 sm:p-6">
      {/* Table Header */}
      <div className="flex items-center px-4 py-4 text-left rounded-lg border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
        <div className="w-[5%]"><WithoutSorttableHeader label="S.L" /></div>
        <div className="w-[25%]"><WithoutSorttableHeader label="CUSTOMER" /></div>
        <div className="w-[55%]"><WithoutSorttableHeader label="REVIEW" /></div>
        <div className="w-[15%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
      </div>

      {/* Table Body */}
      <div className="relative">
        {isLoading ? (
          <div className="h-[400px] flex items-center justify-center">
            <AvatarWithSpinner />
          </div>
        ) : data?.reviews?.length > 0 ? (
          data.reviews.map((gift: any, index: number) => (
            <div
              key={gift.gift_id}
              className={`flex flex-col sm:flex-row gap-4 sm:gap-0 px-4 py-4 border-b border-bordercolor ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"
                }`}
            >
              <div className="sm:w-[5%] text-sm text-textcolor font-poppins">{index + 1}</div>

              <div className="sm:w-[25%]">
                <TableUserInfo
                  profilePic={gift.user.profile_photo_url}
                  username={`${gift.user.first_name} ${gift.user.last_name}`}
                  email={gift.user.email || 'N/A'}
                  mobile={gift.user.country_code ? `${gift.user.country_code} ${gift.user.mobile || ''}` : 'N/A'}
                  onClick={() => { }}
                />
              </div>

              <div className="sm:w-[55%] whitespace-pre-wrap break-words text-textcolor">
                <SimpletextTableBodyReview title={gift.review_message} />
              </div>

              <div className="sm:w-[15%]">
                <TableDateTimeDisplay dateString={gift.created_at} />
              </div>
            </div>
          ))
        ) : (
          <div className="p-4 h-[38rem] flex justify-center items-center">
            <div className="w-full flex flex-col items-center h-full justify-center">
              <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
              <h2 className="font-poppins text-lg text-textcolor mt-4">No  Data Found</h2>
            </div>
          </div>
        )}
      </div>
    </div>
  );
}

export default ReviewsViewVendor;
