import React from 'react'
import WithoutSorttableHeader from '../../../Componets/TableComponets/WithoutSorttableHeader'
import notfound from "../../../assets/Images/notfound.png"
import { UseGetVendordetail } from '../../../Appstore/Api/UseGetVendordetail';
import TableDateTimeDisplay from '../../../Componets/TableComponets/TableDateTimeDisplay';
import SimpletextTableBody from '../../../Componets/TableComponets/SimpletextTableBody';
import AvatarWithSpinner from '../../../Componets/LoadingComponest';

function SponsorsViewVendor() {

  const { data, isLoading } = UseGetVendordetail();

  return (
    <div className=" w-[97%] p-5">
      <div className="flex items-center px-4 py-4 text-left rounded-lg border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
        <div className="w-[4%]"><WithoutSorttableHeader label="S.L" /></div>
        <div className="w-[20%]"><WithoutSorttableHeader label="SPONSOR" /></div>
        <div className="w-[10%]"><WithoutSorttableHeader label="DAYS" /></div>
        <div className="w-[10%]"><WithoutSorttableHeader label="PRICE" /></div>
        <div className="w-[10%]"><WithoutSorttableHeader label="START DATE" /></div>
        <div className="w-[10%]"><WithoutSorttableHeader label="END DATE" /></div>
        <div className="w-[10%]"><WithoutSorttableHeader label="PAYMENT MODE" /></div>
        <div className="w-[16%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
      </div>


      {/* Table Body */}
      <div className="relative">
        {isLoading ? (
          <div className="h-[400px] flex items-center justify-center">
            <AvatarWithSpinner />
          </div>
        ) : data?.sponsors?.length > 0 ? (
          data.sponsors.map((gift: any, index: number) => (
            <div
              key={gift.gift_id}
              className={`flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 text-sm font-poppins gap-4 ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"
                }`}
            >
              <div className="w-[4%]">{index + 1}</div>
              <div className="w-[20%]"><SimpletextTableBody title={gift.goal.campaign.campaign_name} /></div>
              <div className="w-[10%]"><SimpletextTableBody title={gift.goal.days} /></div>
              <div className="w-[10%]"><SimpletextTableBody title={gift.goal.price} /></div>
              <div className="w-[10%]"><SimpletextTableBody title={gift.goal.start_date} /></div>
              <div className="w-[10%]"><SimpletextTableBody title={gift.end_date} /></div>

              {/* Payment Mode */}
              <div className="w-[10%]">
                <div
                  className={`w-fit rounded-xl px-3 py-1 font-medium ${gift?.payment_mode === "user"
                    ? "bg-[#D4F1E0] text-[#4CAF50]"
                    : gift?.payment_mode === "vendor"
                      ? "bg-[#D2DFF5] text-[#0046AE]"
                      : gift?.payment_mode === "stripe"
                        ? "bg-[#E0F7FA] text-[#00ACC1]"
                        : gift?.payment_mode === "flutterwave"
                          ? "bg-[#FFF3E0] text-[#FB8C00]"
                          : gift?.payment_mode === "razorpay"
                            ? "bg-[#F3E5F5] text-[#8E24AA]"
                            : "bg-gray-200 text-gray-600"
                    }`}
                >
                  {{
                    user: "Customer",
                    vendor: "Vendor",
                    stripe: "Stripe",
                    flutterwave: "Flutterwave",
                    razorpay: "Razorpay",
                  }[gift?.payment_mode] || "Unknown"}
                </div>
              </div>

              <div className="w-[16%]"><TableDateTimeDisplay dateString={gift.created_at} /></div>


            </div>
          ))
        ) : (
          <div className="p-4 h-[38rem] flex justify-center items-center">
            <div className="w-full flex flex-col items-center h-full justify-center">
              <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
              <h2 className="font-poppins text-lg text-textcolor mt-4">No  Data Found</h2>
            </div>
          </div>
        )}
      </div>

    </div>
  )
}

export default SponsorsViewVendor
