import React from 'react';
import {
    Document,
    Page,
    View,
    Text,
    StyleSheet,
    Image
} from '@react-pdf/renderer';
import logo from '../../assets/Images/logo.png';

const styles = StyleSheet.create({
    page: {
        padding: 30,
        fontSize: 11,
        fontFamily: 'Helvetica',
        color: '#333',
    },
    header: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        alignItems: 'center',
    },
    logo: {
        width: 140,
        height: 30,
    },
    invoiceTitle: {
        fontSize: 24,
        fontWeight: 'bold',
        color: '#0046AE',
    },
    section: {
        marginTop: 20,
        width: "100%"
    },
    subtitle: {
        fontSize: 13,
        fontWeight: 'bold',
        color: '#0046AE',
        marginBottom: 10,
    },
    badgeRow: {
        flexDirection: 'row',
        gap: 10,
        marginVertical: 6,
        width: "100%",
    },
    badge: {
        paddingHorizontal: 10,
        paddingVertical: 4,
        borderRadius: 4,
        fontSize: 10,
        color: 'white',
    },
    paid: {
        backgroundColor: '#28B765',
    },
    stripe: {
        backgroundColor: '#0046AE',
    },
    box: {
        border: '1px solid #ccc',
        borderRadius: 5,
        padding: 10,
    },
    flexRow: {
        flexDirection: 'row',
        justifyContent: 'space-between',
    },
    table: {
        marginTop: 10,
        border: '1px solid #ccc',
        borderRadius: 5,
    },
    tableRowHeader: {
        flexDirection: 'row',
        backgroundColor: '#D3D3D3',
        padding: 6,
        fontWeight: 'bold',
    },
    tableRow: {
        flexDirection: 'row',
        padding: 6,
        borderTop: '1px solid #ccc',
    },
    col1: { width: '25%' },
    col2: { width: '25%' },
    col3: { width: '15%' },
    col4: { width: '15%' },
    col5: { width: '20%' },
});

const InvoiceDocument = ({ data }: { data: any }) => {
    const category = data?.category || {};

    return (
        <Document>
            <Page size="A4" style={styles.page}>
                {/* Header */}
                <View style={styles.header}>
                    <Image src={logo} style={styles.logo} />
                    <Text style={styles.invoiceTitle}>INVOICE</Text>
                </View>
                <View style={styles.badgeRow}>
                    {/* Subscription Details */}
                    <View style={styles.section}>
                        <Text style={styles.subtitle}>Overview Subscription Information</Text>
                        <View style={styles.box}>
                            <Text>Subscription ID: #{category.id}</Text>
                            <Text>Subscription Date: {category.created_at}</Text>
                            <View style={styles.badgeRow}>
                                <Text style={[styles.badge, styles.paid]}>Paid</Text>
                                <Text style={[styles.badge, styles.stripe]}>{category.payment_mode}</Text>
                            </View>
                        </View>
                    </View>

                    {/* Vendor Details */}
                    <View style={[styles.section]}>
                        <Text style={styles.subtitle}>Vendor Details:</Text>
                        <View style={styles.box}>
                            <Text>{category.vendor_name}</Text>
                            <Text>{category.email}</Text>
                            <Text>{category.mobile}</Text>
                        </View>
                    </View>
                </View>


                {/* Table Summary */}
                <View style={styles.section}>
                    <Text style={styles.subtitle}>Summary:</Text>
                    <View style={styles.table}>
                        <View style={styles.tableRowHeader}>
                            <Text style={styles.col1}>SUBSCRIPTION ID</Text>
                            <Text style={styles.col2}>PLAN NAME</Text>
                            <Text style={styles.col3}>PRICE</Text>
                            <Text style={styles.col4}>START DATE</Text>
                            <Text style={styles.col5}>EXPIRED DATE</Text>
                        </View>
                        <View style={styles.tableRow}>
                            <Text style={styles.col1}>#{category.id}</Text>
                            <Text style={styles.col2}>{category.plan_name}</Text>
                            <Text style={styles.col3}>{category.price}</Text>
                            <Text style={styles.col4}>{category.start_date}</Text>
                            <Text style={styles.col5}>{category.expire_date}</Text>
                        </View>
                    </View>
                </View>
            </Page>
        </Document>
    );
};

export default InvoiceDocument;
