import React from "react";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import { UseGetUserDetail } from "../../Appstore/Api/UseGetUserDetail";
import notfound from "../../assets/Images/notfound.png";
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import TableDateTimeDisplay from "../../Componets/TableComponets/TableDateTimeDisplay";

function LIkeViewuset() {
    const { data, isLoading } = UseGetUserDetail();

    return (
        <div className="w-full px-4 md:px-6 py-5">
            {/* Header */}
            <div className="hidden sm:flex px-4 py-3 text-left border-b w-full bg-headercolortable rounded-lg border-b-bordercolor">
                <div className="w-[10%]">
                    <WithoutSorttableHeader label="S.L" />
                </div>
                <div className="w-[60%]">
                    <WithoutSorttableHeader label="STORE" />
                </div>
                <div className="w-[30%]">
                    <WithoutSorttableHeader label="CREATED DATE/TIME" />
                </div>
            </div>

            <div className="relative">
                {isLoading && (
                    <div className="h-[400px] flex items-center justify-center">
                        <AvatarWithSpinner />
                    </div>
                )}

                {!isLoading && data?.likes?.length > 0 ? (
                    data.likes.map((gift: any, index: number) => (
                        <div
                            key={gift.gift_id}
                            className={`${index % 2 === 0
                                    ? "bg-white dark:bg-primary"
                                    : "bg-[#00162e0a] dark:bg-primary"
                                } flex flex-col sm:flex-row items-start sm:items-center gap-4 sm:gap-0 px-4 py-3 border-b border-b-bordercolor`}
                        >
                            <div className="w-full sm:w-[10%] text-sm text-textcolor font-poppins">
                                {index + 1}
                            </div>

                            <div className="w-full sm:w-[60%] flex gap-3 items-start sm:items-center">
                                <div className="w-10 h-10 rounded-full overflow-hidden flex-shrink-0">
                                    <img
                                        src={gift.service_images[0]}
                                        alt="Service"
                                        className="w-full h-full object-cover"
                                    />
                                </div>

                                <div className="flex flex-col">
                                    <h4 className="text-[#0046AE] text-sm font-poppins line-clamp-1">
                                        {gift.service_name}
                                    </h4>
                                    <p className="text-[#a4a9b4] text-sm font-poppins line-clamp-1">
                                        Price: {gift?.price_range}
                                    </p>
                                </div>
                            </div>

                            <div className="w-full sm:w-[30%]">
                                <TableDateTimeDisplay dateString={gift.created_at} />
                            </div>
                        </div>
                    ))
                ) : (
                    !isLoading && (
                        <div className="p-4 h-[38rem] flex justify-center items-center">
                            <div className="w-full flex flex-col items-center justify-center">
                                <img
                                    src={notfound}
                                    alt="Not Found"
                                    className="w-1/2 max-h-[40vh] object-contain"
                                />
                                <h2 className="font-poppins text-lg text-textcolor mt-4">
                                    No Like Found
                                </h2>
                            </div>
                        </div>
                    )
                )}
            </div>
        </div>
    );
}

export default LIkeViewuset;
