import React from 'react'
import calll from "../../assets/Images/call12.png"
import email from "../../assets/Images/email.png"
import { UseGetUserDetail } from '../../Appstore/Api/UseGetUserDetail'

function ViewUserDetail() {
    const { data, isLoading } = UseGetUserDetail()



    console.log("data" ,data?.user.first_name)

    return (
        <div className='w-full p-4 shadow-md relative rounded-lg h-[15rem] border border-bordercolor flex flex-col items-center justify-center text-center'>
            {/* "Vendor" Badge */}
            <div className='absolute top-5 left-0'>
                <div className='w-fit rounded-r-lg text-[#0046AE] font-medium cursor-pointer bg-[#0046AE14] font-poppins px-2 py-1'>
                    Customer
                </div>
            </div>

            {/* Detail Content */}
            <div className='flex flex-col items-center gap-2'>
                <div className='w-[5rem] h-[5rem] rounded-full overflow-hidden'>
                    <img
                        src={data?.user?.profile_photo_url}
                        alt="Profile"
                        className="w-full h-full object-cover"
                    />
                </div>

                <h3 className='font-poppins text-textcolor font-medium text-lg'>
                    {(data?.user?.first_name && data?.user?.last_name)
                        ? `${data.user.first_name} ${data.user.last_name}`
                        : ' Name'}
                </h3>

                <div className='flex items-center gap-2'>
                    <img src={calll} alt="Call" className="h-4 w-4" />
                    <p className='text-sm font-normal font-poppins text-[#0046AE]'>
                        {data?.user.mobile || 'Phone Number'}
                    </p>
                </div>

                <div className='flex items-center gap-2'>
                    <img src={email} alt="Email" className="h-4 w-4" />
                    <p className='text-sm font-normal font-poppins text-[#0046AE]'>
                        {data?.user?.email || 'Email Address'}
                    </p>
                </div>
            </div>
        </div>
    )
}

export default ViewUserDetail
