export interface GiftCategory {
    status: boolean;
    message: string;
    data: Datum[];
    Pagination: Pagination;
}

export interface Pagination {
    total_pages: number;
    total_records: number;
    current_page: number;
    records_per_page: number;
}

export interface Datum {
    id: number;
    category_name: string;
    category_image: string;
    created_at: Date;
    subcategories_count: number;
    total_services: number;
}

export interface RemoveServiceImagesRes {
    vendor_id: string;
    service_id: string;
    service_image_id: string;
}



export interface CategoryUpdate {
    status: boolean;
    message: string;
    category: Category;
}

export interface Category {
    id: number;
    category_name: string;
    category_image: string;
}



// category values


export interface CategoryValues {
    status: boolean;
    message: string;
    subcategory: Subcategory;
}

export interface Subcategory {
    id: number;
    subcategory_name: string;
    category_id: number;
    subcategory_image: string;
}


//  store list


export interface StoreListRes {
    status: boolean;
    message: string;
    ServiceList: ServiceList[];
    Pagination: Pagination;
}

export interface Pagination {
    total_pages: number;
    total_records: number;
    current_page: number;
    records_per_page: number;
}

export interface ServiceList {
    id: number;
    category_id: number;
    service_name: string;
    vendor_id: number;
    address: string;
    lat: string;
    lon: string;
    city: null | string;
    published_year: string;
    created_at: Date;
    category_name: string;
    service_images: string[];
    vendor_name: VendorName;
    email: Email;
    image: string;
    avg_review: string;
    price_range: string;
}


// types.ts
export interface StoreAttachment {
    id: number;
    store_attachments: string;
}

export interface StoreImage {
    id: number;
    store_images: string;
}

export interface ServiceDetails {
    id: number;
    service_id: string;
    store_name: string;
    store_description: string;
    subcategory_id: number | null;
    subcategory_name: string | null;
    price: string;
    storeAttachments: StoreAttachment[];
    storeImages: StoreImage[];
    created_at: string;
    updated_at: string;
}


export interface VendorRes {
    status: boolean;
    message: string;
    vendors: Vendor[];
    Pagination: Pagination;
}

export interface Pagination {
    total_pages: number;
    total_records: number;
    current_page: number;
    records_per_page: number;
}

export interface Vendor {
    id: number;
    first_name: string;
    last_name: string;
    username: string;
    email: string;
    created_at: Date;
    mobile: string;
    image: string;
    status: number;
}



//  sub category list  drop dwon


export interface SubCategoryRes {
    status: boolean;
    message: string;
    totalSubCategoryCount: number;
    subCategoryData: SubCategoryDatum[];
}

export interface SubCategoryDatum {
    id: number;
    category_id: number;
    subcategory_name: string;
    subcategory_image: string;
    services_count: number;
}


//  get vendor detail


export interface GetVendorDetailRes {
    status: boolean;
    message: string;
    vendor: UserClass;
    default_currency: string;
    total_store_count: number;
    total_review_count: number;
    total_like_count: number;
    total_lead_count: number;
    stores: Store[];
    services: Service[];
    reviews: any[];
    subscriptions: Subscription[];
    sponsors: Sponsor[];
}

export interface Service {
    id: number;
    vendor_id: number;
    category_id: number;
    subcategory_id: string;
    service_name: string;
    service_description: string;
    service_website: null | string;
    service_country_code: string;
    service_phone: string;
    service_email: string;
    address: string;
    lat: string;
    lon: string;
    area: null | string;
    city: null | string;
    state: null | string;
    country: null | string;
    status: number;
    open_days: string;
    closed_days: null;
    open_time: string;
    close_time: string;
    is_featured: number;
    instagram_link: null | string;
    facebook_link: null;
    whatsapp_link: null | string;
    twitter_link: null;
    video_thumbnail: string;
    video: string;
    video_url: null;
    cover_image: string;
    aspect_ratio: null;
    employee_strength: string;
    published_month: string;
    published_year: string;
    request_approval: number;
    meta_title: null;
    meta_description: null;
    notify_count: number;
    service_address: null | string;
    created_at: Date;
    updated_at: Date;
    price_range?: string;
    category?: Category;
    service_images?: ServiceImage[];
    vendor?: UserClass;
}

export interface Category {
    id: number;
    category_name: string;
    category_image: string;
    created_at: Date;
    updated_at: Date;
}

export interface ServiceImage {
    id: number;
    service_id: number;
    service_images: string;
    created_at: Date;
    updated_at: Date;
}

export interface UserClass {
    id: number;
    first_name: string;
    last_name: string;
    email: string;
    image: null;
    profile_photo_url: string;
}

export interface Sponsor {
    id: number;
    goal_id: number;
    campaign_id: number;
    vendor_id: number;
    service_id: number;
    payment_mode: string;
    price: string;
    end_date: string;
    created_at: Date;
    updated_at: Date;
    goal: Goal;
    service: Service;
    vendor: CampaignVendor;
}

export interface Goal {
    id: number;
    campaign_id: number;
    start_date: string;
    end_date: string;
    days: string;
    price: string;
    status: number;
    created_at: Date;
    updated_at: Date;
    campaign: Campaign;
}

export interface Campaign {
    id: number;
    vendor_id: number;
    service_id: number;
    campaign_name: string;
    address: string;
    lat: string;
    lon: string;
    area_distance: string;
    created_at: Date;
    updated_at: Date;
    vendor: CampaignVendor;
}

export interface CampaignVendor {
    id: number;
    first_name: string;
    last_name: string;
    email: string;
    login_type: string;
    username: null;
    email_verified_at: null;
    two_factor_confirmed_at: null;
    mobile: string;
    device_token: null;
    otp: null;
    image: null;
    status: number;
    country_code: string;
    role: string;
    is_online: number;
    last_seen: null;
    verify_otp: number;
    stripe_customer_id: null;
    created_at: Date;
    updated_at: Date;
    profile_photo_url: string;
}

export interface Store {
    id: number;
    service_id: string;
    subcategory_id: null;
    store_name: string;
    store_description: string;
    price: string;
    created_at: Date;
    updated_at: Date;
    service: Service;
}

export interface Subscription {
    id: number;
    user_id: string;
    plan_name: string;
    price: string;
    start_date: Date;
    expire_date: Date;
    payment_mode: string;
    status: number;
    is_read: number;
    is_color: number;
    created_at: Date;
    updated_at: Date;
    user: UserClass;
}



export interface GetUserDetailRes {
    status: boolean;
    message: string;
    user: User;
    total_reviews: number;
    total_likes: number;
    reviews: Review[];
    likes: any[];
}

export interface Review {
    created_at: string;
    service_id: number;
    service_name: string;
    service_images: any[];
    review_star: string;
    review_message: string;
}

export interface User {
    id: number;
    first_name: null;
    last_name: null;
    email: null;
    image: null;
    profile_photo_url: string;
}



export interface SettingGeneralSetting {
    status: boolean;
    message: string;
    data: Data;
}

export interface Data {
    id: number;
    name: string;
    default_currency: string;
    default_currency_name: string;
    color_code: string;
    copyright_text: string;
    light_logo_url: string;
    dark_logo_url: string;
    fav_icon_url: string;
    email: string;
}



export interface CurrencyListValues {
    status: boolean;
    message: string;
    currencies: Currency[];
    Pagination: Pagination;
}

export interface Pagination {
    total_pages: number;
    total_records: number;
    current_page: number;
    records_per_page: number;
}

export interface Currency {
    id: number;
    currency: string;
    name: string;
}

export interface PhoneSetup {
    status: boolean;
    message: string;
    data: Data;
}

export interface Data {
    id: number;
    android_url: string;
    android_provider_url: string;
    ios_url: string;
    ios_provider_url: string;
}



export interface MailSetupSetting {
    status: boolean;
    message: string;
    data: Data;
}

export interface Data {
    id: number;
    mail_mailer: string;
    mail_host: string;
    mail_port: string;
    mail_encryption: string;
    mail_username: string;
    mail_password: string;
    mail_from: string;
}


export interface SocialTypeSetting {
    status: boolean;
    message: string;
    data: Data;
}

export interface Data {
    id: number;
    facebook_link: string;
    whatsapp_link: string;
    instagram_link: string;
    twitter_link: string;
    youtube_link: string;
    linkdln_link: string;
    share_link: string;
}


export interface RefundPolicyRes {
    status: boolean;
    message: string;
    data: Data;
}

export interface Data {
    id: number;
    text: string;
}


export interface CityName {
    status: boolean;
    message: string;
    cities: string[];
}


export interface Dashboards {
    status: boolean;
    message: string;
    data: Data;
}

export interface Data {
    totals: Totals;
    chartData: ChartData;
    recentServices: RecentService[];
    recentStores: RecentStore[];
    recentVendors: RecentVendor[];
    defaultCurrency: string;
}

export interface ChartData {
    year: string;
    month: string;
    monthName: string;
    days: string[];
    userCounts: string[];
    vendorCounts: string[];
}

export interface RecentService {
    id: number;
    vendor_id: number;
    category_id: number;
    subcategory_id: string;
    service_name: string;
    service_description: string;
    service_website: null | string;
    service_country_code: string;
    service_phone: string;
    service_email: string;
    address: string;
    lat: string;
    lon: string;
    area: string;
    city: string;
    state: string;
    country: null | string;
    status: number;
    open_days: string;
    closed_days: null | string;
    open_time: string;
    close_time: string;
    is_featured: number;
    instagram_link: null | string;
    facebook_link: null | string;
    whatsapp_link: null | string;
    twitter_link: null | string;
    video_thumbnail: null;
    video: null;
    video_url: null | string;
    cover_image: string;
    aspect_ratio: null;
    employee_strength: null | string;
    published_month: null | string;
    published_year: string;
    request_approval: number;
    meta_title: null | string;
    meta_description: null | string;
    notify_count: number;
    service_address: null | string;
    created_at: Date;
    updated_at: Date;
    price_range: string;
    category: Category;
    service_images: ServiceImage[];
    vendor: Vendor;
}

export interface Category {
    id: number;
    category_name: string;
    category_image: string;
    created_at: Date;
    updated_at: Date;
}

export interface ServiceImage {
    id: number;
    service_id: number;
    service_images: string;
    created_at: Date;
    updated_at: Date;
}

export interface Vendor {
    id: number;
    first_name: string;
    last_name: string;
    email: string;
    image: null | string;
    profile_photo_url: string;
}

export interface RecentStore {
    id: number;
    service_id: string;
    subcategory_id: number | null;
    store_name: string;
    store_description: string;
    price: string;
    created_at: Date;
    updated_at: Date;
    store_images: StoreImage[];
    service: Service;
}

export interface Service {
    id: number;
    service_name: string;
    vendor_id: number;
    vendor: Vendor;
}

export interface StoreImage {
    id: number;
    store_id: number;
    store_images: string;
    created_at: Date;
    updated_at: Date;
}

export interface RecentVendor {
    id: number;
    user_id: string;
    plan_name: string;
    price: string;
    start_date: Date;
    expire_date: Date;
    payment_mode: string;
    status: number;
    is_read: number;
    is_color: number;
    created_at: Date;
    updated_at: Date;
    user: Vendor | null;
}

export interface Totals {
    totalUsers: number;
    totalVendors: number;
    totalServices: number;
    totalSubscriptions: number;
    totalStores: number;
}



export interface PaymentSetting {
    status: boolean;
    message: string;
    all_payment: AllPayment[];
}

export interface AllPayment {
    id: string;
    status: string;
    text: string;
    public_key: string;
    secret_key: string;
    mode: string;
    country_code: string;
    currency_code: string;
}



//  store view detail



export interface AdminStoreView {
    status:  boolean;
    message: string;
    service: Service;
}

export interface Service {
    id:           number;
    service_name: string;
    vendor:       Vendor;
    stores:       Stores;
}

export interface Stores {
    id:                number;
    service_name:      string;
    category_id:       number;
    subcategory_id:    string;
    lat:               string;
    lon:               string;
    employee_strength: string;
    open_days:         string;
    closed_days:       null;
    open_time:         string;
    close_time:        string;
    created_at:        Date;
    service_images:    ServiceImage[];
}

export interface ServiceImage {
    id:  number;
    url: string;
}

export interface Vendor {
    id:         number;
    first_name: string;
    last_name:  string;
    email:      string;
    image:      string;
}





export interface NlyticalCOngiguration {
    response_code:   string;
    message:         string;
    status:          string;
    groupedResponse: GroupedResponse[];
}

export interface GroupedResponse {
    id:     string;
    text:   string;
    status: string;
}