import React, { Suspense, lazy } from "react";
import { Routes, Route, Navigate } from "react-router-dom";
import { useAuth } from "../utils/AuthContext";
import ProtectedRoute from "./ProtectedRoute";

// Installation Pages
const Page1 = lazy(() => import("../Pages/SoftwareInstallation/Page1"));
const Page2 = lazy(() => import("../Pages/SoftwareInstallation/Page2"));
const Page3 = lazy(() => import("../Pages/SoftwareInstallation/Page3"));
const Page4 = lazy(() => import("../Pages/SoftwareInstallation/Page4"));
const Page5 = lazy(() => import("../Pages/SoftwareInstallation/Page5"));

// Auth
const SignIn = lazy(() => import("../Pages/Admin_Login/Bothleftandright"));

// Dashboard and Profile
const Dashboard = lazy(() => import("../Pages/Dashboard/Dashboard"));
const Profile = lazy(() => import("../Pages/Admin_Profile/Profile"));

// User Management
const UserList = lazy(() => import("../Pages/UserList/UserList"));
const Gift = lazy(() => import("../Pages/Customer/Customer"));
const ReelList = lazy(() => import("../Pages/ReelList/ReelList"));
const PostList = lazy(() => import("../Pages/AllUserList/AllUserList"));
const User_ReportList = lazy(() => import("../Pages/User_ReportList/User_ReportList"));
const Post_ReportList = lazy(() => import("../Pages/Post_ReportList/Post_ReportList"));
const ReelReportList = lazy(() => import("../Pages/ReelReportList/ReelReportList"));
const ViewUser = lazy(() => import("../Pages/ViewUser/ViewUser"));

// Vendor & Services
const GiftCategoryList = lazy(() => import("../Pages/VendorList/VendorList"));
const AddVendor = lazy(() => import("../Pages/AddVendor/AddVendor"));
const VendorView = lazy(() => import("../Pages/VendorView/VendorView"));

// Finance
const Recharge = lazy(() => import("../Pages/Recharge/Recharge"));
const Withdrawal = lazy(() => import("../Pages/withdrawal/Withdrawal"));

// Misc
const Livelist = lazy(() => import("../Pages/Livelist/Livelist"));
const UsersByCountry = lazy(() => import("../Pages/UsersByCountry/UsersByCountry"));
const HashtagList = lazy(() => import("../Pages/HashtagList/HashtagList"));
const BlockList = lazy(() => import("../Pages/BlockList/BlockList"));
const AvatarList = lazy(() => import("../Pages/AvatarList/AvatarList"));
const LanguageList = lazy(() => import("../Pages/LanguageList/LanguageList"));
const LanguageTranslate = lazy(() => import("../Pages/LanguageList/LanguageTranslate"));

// CMS Pages
const CMS_Page = lazy(() => import("../Pages/CMS_Page/CMS_Page"));
const PrivacyPolicy = lazy(() => import("../Pages/CMS_Page/PrivacyPage"));
const TermsConditions = lazy(() => import("../Pages/CMS_Page/TermsConditions"));
const DeleteAccountCms = lazy(() => import("../Pages/CMS_Page/DeleteAccountCms"));
const CancellationPolicy = lazy(() => import("../Pages/CMS_Page/CancellationPolicy"));
const About12 = lazy(() => import("../Pages/CMS_Page/About12"));
const Contact = lazy(() => import("../Pages/CMS_Page/Contact"));

const FAQLIst = lazy(() => import("../Pages/FAQ/FAQLIst"));
const ReportText = lazy(() => import("../Pages/ReportText/ReportText"));
const ClientReview = lazy(() => import("../Pages/ClientReview/ClientReview"));

// Subscription
const SubscriptionPlan = lazy(() => import("../Pages/SubscriptionPlan/SubscriptionPlan"));
const SubscribedVendor = lazy(() => import("../Pages/SubscribedVendor/SubscribedVendor"));
const ViewSubscribedVendor = lazy(() => import("../Pages/ViewSubscribedVendor/ViewSubscribedVendor"));

// Services
const CategoryList = lazy(() => import("../Pages/CategoryList/CategoryList"));
const SubCategoryList = lazy(() => import("../Pages/SubCategoryList/SubCategoryList"));
const ServiceReviewsList = lazy(() => import("../Pages/ServiceReviewsList/ServiceReviewsList"));
const StoreList = lazy(() => import("../Pages/StoreList/StoreList"));
const AddStore = lazy(() => import("../Pages/AddStore/AddStore"));
const UpdateStore = lazy(() => import("../Pages/UpdateStore/UpdateStore"));
const StoreView = lazy(() => import("../Pages/StoreView/StoreView"));
const ServiceList = lazy(() => import("../Pages/ServiceList/ServiceList"));
const AddService = lazy(() => import("../Pages/AddService/AddService"));
const ServiceUpdate = lazy(() => import("../Pages/ServiceUpdate/ServiceUpdate"));

// Others
const SponsorList = lazy(() => import("../Pages/SponsorList/SponsorList"));
const SponsorListView = lazy(() => import("../Pages/SponsorListView/SponsorListView"));
const Slider = lazy(() => import("../Pages/Slider/Slider"));
const FrontEnd = lazy(() => import("../Pages/FrontEnd/FrontEnd"));
const Setting = lazy(() => import("../Pages/Setting/Setting"));
const Payment = lazy(() => import("../Pages/Setting/Payment/Payment"));
const Music = lazy(() => import("../Pages/Music/Music"));
const AppFeedback = lazy(() => import("../Pages/AppFeedback/AppFeedback"));
const CustomerSupport = lazy(() => import("../Pages/CustomerSupport/CustomerSupport"));
const SubscribedEmail = lazy(() => import("../Pages/SubscribedEmail/SubscribedEmail"));
const UserProfile = lazy(() => import("../Pages/UserProfile/UserProfile"));
const Currencies = lazy(() => import("../Pages/Currencies/Currencies"));

const AppRoutes: React.FC = () => {
  const { authStatus } = useAuth();

  return (
    <Suspense fallback={<div className="text-center mt-10">Loading...</div>}>
      <Routes>
        {authStatus === "not_found" || sessionStorage.getItem("show_varification_steps") ? (
          <>
            <Route path="/nlytical-install-1" element={<Page1 />} />
            <Route path="/nlytical-install-2" element={<Page2 />} />
            <Route path="/nlytical-install-3" element={<Page3 />} />
            <Route path="/nlytical-install-4" element={<Page4 />} />
            <Route path="/nlytical-install-5" element={<Page5 />} />
            <Route path="*" element={<Navigate to="/nlytical-install-1" replace />} />
          </>
        ) : (
          <>
            <Route path="/signin" element={<SignIn />} />
            <Route element={<ProtectedRoute isAuthenticated={authStatus === "valid"} />}>
              <Route path="/dashboard" element={<Dashboard />} />
              <Route path="/user-list" element={<UserList />} />
              <Route path="/Profile" element={<Profile />} />
              <Route path="/customer-list" element={<Gift />} />
              <Route path="/reel-list" element={<ReelList />} />
              <Route path="/alluser-list" element={<PostList />} />
              <Route path="/user-report-list" element={<User_ReportList />} />
              <Route path="/post-report-list" element={<Post_ReportList />} />
              <Route path="/reel-report-list" element={<ReelReportList />} />
              <Route path="/View-User" element={<ViewUser />} />
              <Route path="/Vendor-List" element={<GiftCategoryList />} />
              <Route path="/add-vendor" element={<AddVendor />} />
              <Route path="/View-Vendor" element={<VendorView />} />
              <Route path="/recharge-list" element={<Recharge />} />
              <Route path="/withrawal-list" element={<Withdrawal />} />
              <Route path="/live-list" element={<Livelist />} />
              <Route path="/country-wise-users" element={<UsersByCountry />} />
              <Route path="/hashtag-list" element={<HashtagList />} />
              <Route path="/block-list" element={<BlockList />} />
              <Route path="/avatar-list" element={<AvatarList />} />
              <Route path="/language-list" element={<LanguageList />} />
              <Route path="/language-list/:statusId" element={<LanguageTranslate />} />
              <Route path="/cms" element={<CMS_Page />} />
              <Route path="/privacy-policy" element={<PrivacyPolicy />} />
              <Route path="/termsconditions" element={<TermsConditions />} />
              <Route path="/refund-policy" element={<DeleteAccountCms />} />
              <Route path="/cancellation-policy" element={<CancellationPolicy />} />
              <Route path="/about" element={<About12 />} />
              <Route path="/contact-us" element={<Contact />} />
              <Route path="/faq-list" element={<FAQLIst />} />
              <Route path="/report-text" element={<ReportText />} />
              <Route path="/testimonials-list" element={<ClientReview />} />
              <Route path="/subscription-list" element={<SubscriptionPlan />} />
              <Route path="/subscribed-vendor" element={<SubscribedVendor />} />
              <Route path="/:source/view-subscribed-vendor" element={<ViewSubscribedVendor />} />
              <Route path="/category-list" element={<CategoryList />} />
              <Route path="/subcategory-list" element={<SubCategoryList />} />
              <Route path="/review-list" element={<ServiceReviewsList />} />
              <Route path="/store-list" element={<StoreList />} />
              <Route path="/add-store" element={<AddStore />} />
              <Route path="/:source/update-store" element={<UpdateStore />} />
              <Route path="/:source/view-store" element={<StoreView />} />
              <Route path="/service-list" element={<ServiceList />} />
              <Route path="/add-service" element={<AddService />} />
              <Route path="/:source/update-service" element={<ServiceUpdate />} />
              <Route path="/sponsor-list" element={<SponsorList />} />
              <Route path="/:source/sponsor-list-view" element={<SponsorListView />} />
              <Route path="/slider-list" element={<Slider />} />
              <Route path="/front-end" element={<FrontEnd />} />
              <Route path="/settings" element={<Setting />} />
              <Route path="/payment-method" element={<Payment />} />
              <Route path="/music-list" element={<Music />} />
              <Route path="/app-feedback" element={<AppFeedback />} />
              <Route path="/customer-support" element={<CustomerSupport />} />
              <Route path="/subscribed-email" element={<SubscribedEmail />} />
              <Route path="/:source/user-profile" element={<UserProfile />} />
              <Route path="/currencies-list" element={<Currencies />} />
            </Route>
            <Route path="/" element={<Navigate to="/signin" replace />} />
            <Route path="*" element={<Navigate to="/signin" replace />} />
          </>
        )}
      </Routes>
    </Suspense>
  );
};

export default AppRoutes;