import { useLocation } from "react-router-dom";
import Sidebar from "../Componets/Sidebar/Sidebar";
import { useSelector } from "react-redux";
import { selectAnyModalOpen } from "../Appstore/Slice/ModalSlice";
import { useAuth } from "../utils/AuthContext";
import AvatarWithSpinner from "../Componets/LoadingComponest";

interface MainLayoutProps {
  children: React.ReactNode;
}

const hideSidebarRoutes = ["/signin"];

const MainLayout: React.FC<MainLayoutProps> = ({ children }) => {
  const isAnyModalOpen = useSelector(selectAnyModalOpen);

  const location = useLocation();
  const { authStatus } = useAuth();

  const hideSidebarRoutes = [
    "/signin",
    "/nlytical-install-1",
    "/nlytical-install-2",
    "/nlytical-install-3",
    "/nlytical-install-4",
    "/nlytical-install-5",
  ];

  const hideSidebar = hideSidebarRoutes.some((route) =>
    location.pathname.startsWith(route)
  );

  console.log("Auth Status 123@@@", authStatus)

  if (authStatus === "loading") {
    return (
      <>
        <div className="flex items-center justify-center py-48 place-items-center">
          <AvatarWithSpinner />
        </div>
      </>
    )
  }

  return (
    <div className="min-h-screen xl:flex bg-primary">
      {!hideSidebar && (
        <div
          className="hidden xl:block"
          style={{ zIndex: isAnyModalOpen ? 10 : 100 }}
        >
          <Sidebar isOpen={true} onClose={() => { }} />
        </div>
      )}
      <div className="xl:flex-1">{children}</div>
    </div>
  );
};

export default MainLayout;
