// context/AuthContext.js
import { createContext, useContext, useState, useEffect } from "react";
import axios from "axios";

const AuthContext = createContext();

export const AuthProvider = ({ children }) => {
  const [authStatus, setAuthStatus] = useState("loading"); // 'loading' | 'valid' | 'not_found'

  const verifyToken = async () => {
    try {
      const res = await axios.post(`${import.meta.env.VITE_API_URL}/verified-token`);
      const { message, error } = res.data;

      if (message === "Token verification successful!") {
        setAuthStatus("valid");
      } else {
        setAuthStatus("not_found");
      }
    } catch {
      setAuthStatus("not_found")
    }
  };

  useEffect(() => {
    verifyToken();
  }, []);

  return (
    <AuthContext.Provider value={{ authStatus, verifyToken }}>
      {children}
    </AuthContext.Provider>
  );
};

export const useAuth = () => useContext(AuthContext);
