/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#import "AppCheckCore/Sources/Public/AppCheckCore/GACAppCheckTokenResult.h"

#import "AppCheckCore/Sources/Public/AppCheckCore/GACAppCheckToken.h"

/// Placeholder value that indicates failure.
/// This value is `{"error":"UNKNOWN_ERROR"}` encoded as base64.
static NSString *const kPlaceholderTokenValue = @"eyJlcnJvciI6IlVOS05PV05fRVJST1IifQ==";

@implementation GACAppCheckTokenResult

- (instancetype)initWithToken:(GACAppCheckToken *)token error:(NSError *)error {
  if (self = [super init]) {
    _token = token;
    _error = error;
  }

  return self;
}

- (instancetype)initWithToken:(GACAppCheckToken *)token {
  return [self initWithToken:token error:nil];
}

- (instancetype)initWithError:(NSError *)error {
  return [self initWithToken:[GACAppCheckTokenResult placeholderToken] error:error];
}

#pragma mark - Internal

+ (GACAppCheckToken *)placeholderToken {
  return [[GACAppCheckToken alloc] initWithToken:kPlaceholderTokenValue
                                  expirationDate:[NSDate distantPast]];
}

@end
