<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class PayPalController extends BaseController
{
    private $clientId = 'AVzMVWctLyouPgmfv9Nh6E5KakydG4JHiFGm-fgg6HRqFYUW-gHVKS1ebRfPgDOr2uYABGGcnU_3RaSL';     // 🔹 PayPal Client ID
    private $clientSecret = 'EGWCyNAp9oTXjlmckT8DO9lepyKFrWQy2KvPPmrUsard4K98fuArUYbFQl7CaHdhk4Ehdg_hPkToods4'; // 🔹 PayPal Client Secret
    private $baseUrl = 'https://api-m.sandbox.paypal.com'; // 🔹 Use api-m.paypal.com in LIVE

    /**
     * Get Access Token from PayPal
     */
    private function getAccessToken()
    {
        $response = Http::withBasicAuth($this->clientId, $this->clientSecret)
            ->asForm()
            ->post($this->baseUrl . '/v1/oauth2/token', [
                'grant_type' => 'client_credentials',
            ]);

        if ($response->failed()) {
            throw new \Exception('Unable to generate PayPal access token');
        }

        return $response->json()['access_token'];
    }

    /**
     * Create PayPal Order
     */
    public function PayPalCheckout(Request $request)
    {
        try {
            $token = $this->getAccessToken();

            $response = Http::withToken($token)
                ->post($this->baseUrl . '/v2/checkout/orders', [
                    'intent' => 'CAPTURE',
                    'purchase_units' => [[
                        'amount' => [
                            'currency_code' => 'USD',
                            'value' => $request->amount,
                        ]
                    ]]
                ]);

            $data = $response->json();

            return response()->json([
                'order_id' => $data['id'] ?? null
            ], $response->status());
        } catch (\Exception $ex) {
            return response()->json([
                'error' => 'PayPal Error',
                'message' => $ex->getMessage()
            ], 500);
        }
    }

    /**
     * Capture PayPal Order
     */
    public function captureOrder(Request $request)
    {
        try {
            $token = $this->getAccessToken();
            $orderId = $request->order_id;

            $response = Http::withToken($token)
                ->post($this->baseUrl . "/v2/checkout/orders/{$orderId}/capture");

            return response()->json($response->json(), $response->status());
        } catch (\Exception $ex) {
            return response()->json([
                'error' => 'PayPal Error',
                'message' => $ex->getMessage()
            ], 500);
        }
    }
}
