<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class OtpVerify extends Mailable
{
    use Queueable, SerializesModels;

    public $email;
    public $otp;
    public $first_name;


    /**
     * Create a new message instance.
     */
    public function __construct($email, $otp, $first_name)
    {
        $this->email = $email;
        $this->otp = $otp;
        $this->first_name = $first_name;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->view('OtpVerify')
            ->with([
                'email' => $this->email,
                'otp' => $this->otp,
                'first_name' => $this->first_name,
            ]);
    }
}
