<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class WelcomeEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $email;
    public $first_name;


    /**
     * Create a new message instance.
     */
    public function __construct($email, $first_name)
    {
        $this->email = $email;
        $this->first_name = $first_name;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->view('WelcomeEmail')
            ->with([
                'email' => $this->email,
                'first_name' => $this->first_name,
            ]);
    }
}
