<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppFeedback extends Model
{
    use HasFactory;

    protected $guard = 'admin';
    protected $table = 'app_feedback';

    protected $fillable = [
        'id',
        'user_id',
        'feedback_star',
        'feedback_review',
        'created_at',
        'updated_at',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
