<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
  use HasFactory;
  protected $guard = 'admin';
  protected $table = 'categories';

  protected $fillable = [
    'id',
    'category_name',
    'category_image',
    'created_at',
    'updated_at',
    'category_icon',
  ];

  public function subcategories()
  {
    return $this->hasMany(SubCategory::class);
  }

  public function products()
  {
    return $this->hasMany(Service::class, 'category_id'); // Adjust 'category_id' if necessary
  }


  public function services()
  {
    return $this->hasMany(Service::class, 'category_id');
  }
}
