<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Goals extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'goals';

    protected $fillable = [
        'id',
        'campaign_id',
        'start_date',
        'end_date',
        'days',
        'price',
        'created_at',
        'updated_at',
    ];

    // public function campaign()
    // {
    //     return $this->belongsTo(Campaign::class, 'campaign_id');
    // }

    public function campaign()
    {
        return $this->belongsTo(Campaign::class, 'campaign_id', 'id');
    }
}
