<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IndexCategories extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'home_categories';

    protected $fillable = [
        'id',
        'category_id',
        'created_at',
        'updated_at',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
}
