<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IndexCities extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'indexcities';

    protected $fillable = [
        'id',
        'service_id',
        'title',
        'subtext',
        'created_at',
        'updated_at',
        'city'
    ];

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }
}
