<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PlanDescription extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'plan_description';

    protected $fillable = [
        'id',
        'plan_services',
        'plan_id',
        'status',
        'created_at',
        'updated_at',
    ];

    public function subscriptionPlan()
    {
        return $this->belongsTo(SubscriptionPlan::class, 'plan_id');
    }
}
