<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $guard = 'admin';
    protected $table = 'services';

    protected $fillable = [
        'id',
        'vendor_id',
        'category_id',
        'subcategory_id',
        'service_name',
        'service_description',
        'service_country_code',
        'service_website',
        'service_phone',
        'service_email',
        'address',
        'lat',
        'lon',
        'status',
        'open_days',
        'closed_days',
        'open_time',
        'close_time',
        'is_featured',
        'instagram_link',
        'facebook_link',
        'whatsapp_link',
        'twitter_link',
        'video_thumbnail',
        'video',
        'video_url',
        'aspect_ratio',
        'employee_strength',
        'published_month',
        'published_year',
        'request_approval',
        'cover_image',
        'area',
        'state',
        'city',
        'country',
        'service_address',
        'created_at',
        'updated_at',
        'meta_title',
        'meta_description',
        'is_delete',
    ];

    public function serviceImages()
    {
        return $this->hasMany(ServiceImages::class, 'service_id', 'id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    // Define the relationship with the User model
    public function user()
    {
        return $this->belongsTo(User::class, 'vendor_id');
    }

    // Define the user relationship
    public function vendor()
    {
        return $this->belongsTo(User::class, 'vendor_id');
    }
}
