<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceLead extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'services_lead';

    protected $fillable = [
        'id',
        'service_id',
        'created_at',
        'updated_at',
    ];

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'id');
    }
}
