<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceReview extends Model
{
  use HasFactory;

  protected $guard = 'admin';
  protected $table = 'service_review';

  protected $fillable = [
    'id',
    'user_id',
    'service_id',
    'review_star',
    'review_message',
    'created_at',
    'updated_at',
  ];

  public function service()
  {
    return $this->belongsTo(Service::class, 'service_id', 'id');
  }

  public function user()
  {
    return $this->belongsTo(User::class, 'user_id', 'id');
  }

  public function serviceImages()
  {
    return $this->hasMany(ServiceImages::class, 'service_id', 'service_id');
  }
}
