<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stores extends Model
{
    use HasFactory;

    protected $guard = 'admin';
    protected $table = 'stores';

    protected $fillable = [
        'id',
        'service_id',
        'store_name',
        'store_description',
        'price',
        'subcategory_id',
        'created_at',
        'updated_at',
        'is_delete',
    ];

    public function storeImages()
    {
        return $this->hasMany(StoreImages::class, 'store_id', 'id');
    }

    public function storeAttachments()
    {
        return $this->hasMany(StoreAttachments::class, 'store_id', 'id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'id');
    }

    public function subcategory()
    {
        return $this->belongsTo(SubCategory::class, 'subcategory_id');
    }
}
