<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserSubscription extends Model
{
  use HasFactory;
  protected $guard = 'admin';
  protected $table = 'user_subscription_plan';

  protected $fillable = [
    'id',
    'user_id',
    'plan_name',
    'price',
    'start_date',
    'expire_date',
    'payment_mode',
    'status',
    'created_at',
    'updated_at',
    'subtext',
    'subscription_id',
  ];


  public function user()
  {
    return $this->belongsTo(User::class, 'user_id');
  }
}
