<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('admin_notifications', function (Blueprint $table) {
            $table->integer('id', false, true)->length(11)->autoIncrement(); // int(11) unsigned
            $table->text('title')->nullable(); // Title (nullable)
            $table->text('message')->nullable(); // Message (nullable)
            $table->timestamps(); // created_at and updated_at
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admin_notifications');
    }
};
