<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('app_feedback', function (Blueprint $table) {
            $table->integer('id', false, true)->length(11)->autoIncrement(); // int(11) unsigned
            $table->integer('user_id', false, true)->length(11)->nullable(); // int(11) unsigned nullable
            $table->text('feedback_review')->nullable(); // Feedback review (nullable)
            $table->timestamps(); // created_at and updated_at
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('app_feedback');
    }
};
