<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class CreateAdminsTable extends Migration
{
    public function up()
    {
        Schema::create('admins', function (Blueprint $table) {
            $table->integer('id', false, true)->length(11)->autoIncrement(); // int(11) unsigned
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('mobile', 12)->nullable();
            $table->string('image')->nullable();
            $table->string('password')->nullable();
            $table->timestamps();
        });

        // Insert default admin record
        DB::table('admins')->insert([
            'id' => 1,
            'first_name' => 'Nlytical',
            'last_name' => null,
            'email' => 'nlyticaladmin@gmail.com',
            'mobile' => '98745632101',
            'image' => '1742375188_image_67da891440c93.png',
            'password' => '$2y$10$p33Mz91SmaupCS32QBaxJOL0uMfiaZCv.MV43crq64Jqz1C5Gb/PO', // hashed password
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('admins');
    }
};
