<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('goal_payment_history', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned
            $table->integer('goal_id', false, true)->length(11)->nullable();
            $table->integer('campaign_id', false, true)->length(11)->nullable();
            $table->integer('vendor_id', false, true)->length(11)->nullable();
            $table->integer('service_id', false, true)->length(11)->nullable();
            $table->text('payment_mode')->nullable();
            $table->text('price')->nullable();
            $table->text('end_date')->nullable();
            $table->text('end_date_do')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('goal_payment_history');
    }
};
