<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_banner', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned AUTO_INCREMENT
            $table->text('play_store_url')->nullable();
            $table->text('app_store_url')->nullable();
            $table->text('image')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('home_banner')->insert([
            'id' => 1,
            'play_store_url' => 'https://primocys.com/',
            'app_store_url' => 'https://nlyticalapp.com/',
            'image' => '174228739367d932210b189.png',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_banner');
    }
};
