<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_seo', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned AUTO_INCREMENT
            $table->text('title')->nullable();
            $table->text('body')->nullable();
            $table->text('image')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('home_seo')->insert([
            'id' => 1,
            'title' => 'Find out best Restaurants, Dentists, Bars, Beauty Salons, Doctors stores.',
            'body' => 'User Reviews and Recommendations of Best Restaurants, Shopping, Nightlife, Food, Entertainment, Things to Do, Services, and More at Nlytical.',
            'image' => '174298889767e3e6619a634.png',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_seo');
    }
};
