<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_gateway_key', function (Blueprint $table) {
            $table->id(); // Auto-increment primary key
            $table->string('text')->nullable();
            $table->string('public_key')->nullable();
            $table->string('secret_key')->nullable();
            $table->string('mode')->nullable(); // e.g., test/live
            $table->integer('status')->default(1); // 1 = active
            $table->text('country_code')->nullable(); // e.g., 'IN'
            $table->text('currency_code')->nullable(); // e.g., 'INR'
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_gateway_key');
    }
};
