<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->integer('vendor_id')->nullable();
            $table->integer('category_id')->nullable();
            $table->text('subcategory_id')->nullable();
            $table->text('service_name')->nullable();
            $table->text('service_description')->nullable();
            $table->text('service_website')->nullable();
            $table->text('service_country_code')->nullable();
            $table->text('service_phone')->nullable();
            $table->text('service_email')->nullable();
            $table->text('address')->nullable();
            $table->text('lat')->nullable();
            $table->text('lon')->nullable();
            $table->text('area')->nullable();
            $table->text('city')->nullable();
            $table->text('state')->nullable();
            $table->text('country')->nullable();
            $table->integer('status')->default(1);
            $table->text('open_days')->nullable();
            $table->text('closed_days')->nullable();
            $table->text('open_time')->nullable();
            $table->text('close_time')->nullable();
            $table->integer('is_featured')->default(0);
            $table->text('instagram_link')->nullable();
            $table->text('facebook_link')->nullable();
            $table->text('whatsapp_link')->nullable();
            $table->text('twitter_link')->nullable();
            $table->text('video_thumbnail')->nullable();
            $table->text('video')->nullable();
            $table->text('video_url')->nullable();
            $table->text('cover_image')->nullable();
            $table->text('aspect_ratio')->nullable();
            $table->text('employee_strength')->nullable();
            $table->text('published_month')->nullable();
            $table->text('published_year')->nullable();
            $table->integer('request_approval')->default(1);
            $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->integer('notify_count')->default(0);
            $table->text('service_address')->nullable();
             $table->string('is_delete')->default('0')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
