<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_review', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary Key
            $table->integer('user_id')->nullable(); // User giving review
            $table->integer('service_id')->nullable(); // Service being reviewed
            $table->text('review_star')->nullable(); // Star rating
            $table->text('review_message')->nullable(); // Review message
            $table->integer('is_read')->nullable()->default(1);
            $table->integer('is_color')->nullable()->default(1);
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_review');
    }
};
