<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('site_setup', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary Key
            $table->text('name')->nullable();
            $table->text('min_amountbook')->nullable();
            $table->text('distance')->nullable();
            $table->text('distance_type')->nullable();
            $table->text('platform_fees')->nullable();
            $table->text('time_zone')->nullable();
            $table->text('default_currency')->nullable();
            $table->text('default_currency_name')->nullable();
            $table->text('copyright_text')->nullable();
            $table->text('google_map_key')->nullable();
            $table->text('light_logo')->nullable();
            $table->text('dark_logo')->nullable();
            $table->text('fav_icon')->nullable();
            $table->text('color_code')->nullable();
            $table->text('purchase_code')->nullable();
            $table->tinyInteger('is_extended')->default(0)->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('site_setup')->insert([
            'id' => 1,
            'name' => 'Nlytical',
            'min_amountbook' => null,
            'distance' => null,
            'distance_type' => null,
            'platform_fees' => null,
            'time_zone' => null,
            'default_currency' => '$',
            'default_currency_name' => 'USD',
            'copyright_text' => 'Copyright 2025 © Nlytical theme by Primocys',
            'google_map_key' => null,
            'light_logo' => '1742290456_light_logo_67d93e18c0bc0.png',
            'dark_logo' => '1742290456_dark_logo_67d93e18c0e50.png',
            'fav_icon' => '1742290456_favicon_67d93e18c0fd6.png',
            'color_code' => '#246fc1',
            'purchase_code' => null,
            'is_extended' => 0,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('site_setup');
    }
};
