<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('slides', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary Key
            $table->text('image')->nullable();
            $table->string('description')->nullable();
            $table->integer('status')->nullable()->default(0);
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });


        // Insert default admin record
        DB::table('slides')->insert([
            'id' => 1,
            'image' => 'slide-1.png',
            'description' => null,
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('slides')->insert([
            'id' => 2,
            'image' => 'slide-2.png',
            'description' => null,
            'status' => 0,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('slides');
    }
};
