<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('social_media', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary Key
            $table->text('facebook_link')->nullable();
            $table->text('whatsapp_link')->nullable();
            $table->text('instagram_link')->nullable();
            $table->text('twitter_link')->nullable();
            $table->text('youtube_link')->nullable();
            $table->text('linkdln_link')->nullable(); // Assuming typo for 'linkedin'
            $table->text('share_link')->nullable(); // Assuming typo for 'linkedin'
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });


        // Insert default admin record
        DB::table('social_media')->insert([
            'id' => 1,
            'facebook_link' => 'https://www.facebook.com/iqonicdesign/',
            'whatsapp_link' => 'https://whatsapp.com/iqonicdesign',
            'instagram_link' => 'https://www.instagram.com/iqonicdesign/?igshid=YmMyMTA2M2Y%3D',
            'twitter_link' => 'https://twitter.com/iqonicdesign',
            'youtube_link' => 'https://www.youtube.com/iqonicdesign',
            'linkdln_link' => 'https://www.linkedin.com/company/iqonicthemes/',
            'share_link' => 'https://primocys.com/',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('social_media');
    }
};
