<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('store_attachments', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary key
            $table->integer('store_id')->nullable(); // Foreign key reference to stores
            $table->text('store_attachments')->nullable(); // Attachment file name or path
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('store_attachments');
    }
};
