<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('theme_setup', function (Blueprint $table) {
            $table->increments('id'); // Primary Key - AUTO_INCREMENT int(11)
            $table->text('logo')->nullable(); // Main logo
            $table->text('footer_logo')->nullable(); // Footer logo
            $table->text('fav_icon')->nullable(); // Favicon
            $table->text('color_code')->nullable(); // Theme color hex code
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('theme_setup')->insert([
            'id' => 1,
            'logo' => '1737439149_logo_678f37ada05fd.png',
            'footer_logo' => '1737439149_footer_678f37ada0915.png',
            'fav_icon' => '1737439149_favicon_678f37ada0a5c.png',
            'color_code' => '#1f58c7',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('theme_setup');
    }
};
