<?php

use App\Http\Controllers\Api\AdminApiController;
use App\Http\Controllers\Api\LanguageController;
use App\Http\Controllers\Api\PayPalController;
use App\Http\Controllers\Api\UserApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserAuthController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\VendorAuthController;
use App\Http\Controllers\Api\WebApiController;
use App\Http\Controllers\Api\SubScriberController;

// UserApiController
Route::post('/newuser-registeraccount', [UserApiController::class, 'newUserRegisterAccount']);
Route::post('/verify-user', [UserApiController::class, 'verifyUser']);
Route::post('/user-login', [UserApiController::class, 'userLogin']);
Route::post('/forgot-password', [UserApiController::class, 'forgotPassword']);
Route::post('/passwordotp-verify', [UserApiController::class, 'passwordOtpVerify']);
Route::post('/reset-password', [UserApiController::class, 'ResetPassword']);
Route::get('/get-privacypolicy', [UserApiController::class, 'getPrivacyPolicy']);
Route::get('/get-termsconditions', [UserApiController::class, 'getTermsConditions']);

Route::get('/get-faq', [UserApiController::class, 'getFaq']);
Route::post('/get-countrieslist', [UserApiController::class, 'getCountriesList']);
Route::post('/get-countriescategories', [UserApiController::class, 'getCountriesCategory']);
Route::post('/social-login', [UserApiController::class, 'socialLogin']);
Route::get('/get-homesettings', [UserApiController::class, 'getHomeSettings']);
Route::post('/username-exist', [UserApiController::class, 'usernameExist']);
Route::post('/login-api', [AdminApiController::class, 'loginApi']);
Route::get('/get-logindata', [AdminApiController::class, 'getLoginData']);
Route::post('/all_login_status', [AdminApiController::class, 'all_login_status']);
Route::post('/add-customersupport', [UserApiController::class, 'addCustomerSupport']);

Route::middleware('sanctum')->group(function () {});

Route::middleware(['auth:api'])->group(function () {

    Route::post('/get-userprofile', [UserAuthController::class, 'userProfile']);
    Route::post('/delete-useraccount', [UserApiController::class, 'deleteUserAccount']);
    Route::post('/app-feedback', [UserApiController::class, 'appFeedback']);
    Route::post('/service-like', [UserAuthController::class, 'serviceLike']);
    Route::post('/get-likedservices', [UserAuthController::class, 'getLikedServices']);
    Route::post('/add-review', [UserAuthController::class, 'addReview']);
    Route::post('/user-reviewlist', [UserAuthController::class, 'userReviewList']);
    Route::post('/update-userprofile', [UserAuthController::class, 'updateUserProfile']);
    Route::post('/search-service', [UserAuthController::class, 'searchService']);
    Route::post('/nearby-services', [UserAuthController::class, 'nearbyService']);
    Route::post('/edit-userreview', [UserAuthController::class, 'editUserReview']);
    Route::post('/delete-userreview', [UserAuthController::class, 'deleteUserReview']);
    Route::post('/block-user', [UserAuthController::class, 'blockUser']);
    Route::post('/unblock-user', [UserAuthController::class, 'unblockUser']);
    Route::post('/report-user', [UserAuthController::class, 'reportUser']);
    Route::post('/vendor-home', [VendorAuthController::class, 'vendorHome']);
    Route::post('/add-service', [VendorAuthController::class, 'addService']);
    Route::post('/update-service', [VendorAuthController::class, 'updateService']);
    Route::post('/add-chat', [VendorAuthController::class, 'addChat']);
    Route::post('/inner-chat', [VendorAuthController::class, 'innerChat']);
    Route::post('/chat-list', [VendorAuthController::class, 'userChatList']);
    Route::post('/payment-success', [SubScriberController::class, 'paymentSuccess']);
    Route::post('/search-vendorservices', [VendorAuthController::class, 'searchVendorServices']);
    Route::post('/remove-serviceimages', [VendorAuthController::class, 'removeServiceImages']);
    Route::post('/total-percentage', [VendorAuthController::class, 'totalPercentage']);
    Route::post('/add-store', [VendorAuthController::class, 'addStore']);
    Route::post('/update-store', [VendorAuthController::class, 'updateStore']);
    Route::post('/remove-storeimages', [VendorAuthController::class, 'removeStoreImages']);
    Route::post('/remove-storeattachments', [VendorAuthController::class, 'removeStoreAttachment']);
    Route::post('/user-online', [VendorAuthController::class, 'userOnline']);
    Route::post('/vendor-info', [VendorAuthController::class, 'vendorInfo']);
    Route::post('/delete-store', [VendorAuthController::class, 'deleteStore']);
    Route::post('/add-campaign', [SubScriberController::class, 'addCampaign']);
    Route::post('/add-goals', [SubScriberController::class, 'addGoals']);
    Route::post('/goalpayment-success', [SubScriberController::class, 'goalPaymentSuccess']);
    Route::post('/get-campaign', [SubScriberController::class, 'getCampaign']);
    Route::post('/get-goals', [SubScriberController::class, 'getGoals']);

    Route::post('/stripe-intent', [SubScriberController::class, 'stripeIntent']);
    Route::post('/get-goalspayment', [SubScriberController::class, 'getGoalsPayment']);
    Route::post('/get-susbcribepayment', [SubScriberController::class, 'getSubscribePayment']);
    Route::post('/get-allsusbcribepayment', [SubScriberController::class, 'getallSubscribePayment']);
    Route::post('/remove-userimage', [VendorAuthController::class, 'removeUserImages']);

    Route::post('/customer-list', [AdminApiController::class, 'customerList']);
    Route::post('/vendors-list', [AdminApiController::class, 'vendorList']);
    Route::post('/vendors-listwithoutpage', [AdminApiController::class, 'vendorListWithoutPagination']);
    Route::post('/allusers-list', [AdminApiController::class, 'allUserList']);
    Route::post('/user-statuschange', [AdminApiController::class, 'userStatusChange']);
    Route::post('/category-list', [AdminApiController::class, 'categoryList']);
    Route::post('/add-category', [AdminApiController::class, 'addCategory']);
    Route::post('/edit-category', [AdminApiController::class, 'editCategory']);
    Route::post('/delete-category', [AdminApiController::class, 'deleteCategory']);
    Route::post('/subcategory-list', [AdminApiController::class, 'subCategoryList']);
    Route::post('/add-subcategory', [AdminApiController::class, 'addSubCategory']);
    Route::post('/edit-subcategory', [AdminApiController::class, 'editSubCategory']);
    Route::post('/delete-subcategory', [AdminApiController::class, 'deleteSubCategory']);
    Route::post('/service-listadmin', [AdminApiController::class, 'serviceListAdmin']);
    Route::post('/service-listwithoutpage', [AdminApiController::class, 'serviceListWithoutPagination']);
    Route::post('/service-listshowpage', [AdminApiController::class, 'serviceListShowPagination']);
    Route::post('/store-listadmin', [AdminApiController::class, 'storeListAdmin']);
    Route::post('/delete-service', [AdminApiController::class, 'deleteService']);
    Route::post('/review-list', [AdminApiController::class, 'ReviewList']);
    Route::post('/add-subscription', [AdminApiController::class, 'addSubscription']);
    Route::post('/edit-subscription', [AdminApiController::class, 'editSubscription']);
    Route::post('/delete-subscription', [AdminApiController::class, 'deleteSubscription']);
    Route::post('/subscribed-users', [AdminApiController::class, 'subscribedUsers']);
    Route::post('/view-subscriber', [AdminApiController::class, 'viewSubscriberUser']);
    Route::post('/sponser-payment', [AdminApiController::class, 'sponserPayment']);
    Route::post('/view-sponserpayment', [AdminApiController::class, 'viewsponserPayment']);
    Route::post('/slider-list', [AdminApiController::class, 'sliderList']);
    Route::post('/update-sliderstatus', [AdminApiController::class, 'updateSliderStatus']);
    Route::post('/add-slider', [AdminApiController::class, 'addSlider']);
    Route::post('/delete-slider', [AdminApiController::class, 'deleteSlider']);
    Route::post('/currencies-list', [AdminApiController::class, 'currencyList']);
    Route::post('/faq-list', [AdminApiController::class, 'faqList']);
    Route::post('/add-currency', [AdminApiController::class, 'addCurrency']);
    Route::post('/delete-currency', [AdminApiController::class, 'deleteCurrency']);
    Route::post('/refund-policy', [AdminApiController::class, 'refundPolicy']);
    Route::post('/cancel-policy', [AdminApiController::class, 'cancelPolicy']);
    Route::post('/about', [AdminApiController::class, 'about']);
    Route::post('/contact-us', [AdminApiController::class, 'contactUs']);
    Route::post('/privacy-policy', [AdminApiController::class, 'privacyPolicy']);
    Route::post('/terms-conditions', [AdminApiController::class, 'termsConditions']);
    Route::post('/nearby-distance', [AdminApiController::class, 'nearbyDistance']);
    Route::post('/add-faq', [AdminApiController::class, 'addFaq']);
    Route::post('/edit-faq', [AdminApiController::class, 'editFaq']);
    Route::post('/delete-faq', [AdminApiController::class, 'deleteFaq']);
    Route::post('/add-reporttext', [AdminApiController::class, 'addReportText']);
    Route::post('/delete-reporttext', [AdminApiController::class, 'deleteReportText']);
    Route::post('/client-reviews', [AdminApiController::class, 'clientReviews']);
    Route::post('/add-clientreviews', [AdminApiController::class, 'addClientReviews']);
    Route::post('/delete-clientreviews', [AdminApiController::class, 'deleteClientReviews']);
    Route::post('/delete-customersupport', [AdminApiController::class, 'deleteCustomerSupport']);
    Route::post('/payment-update', [AdminApiController::class, 'paymentUpdate']);
    Route::post('/feedback-list', [AdminApiController::class, 'feedbackList']);
    Route::post('/customer-support', [AdminApiController::class, 'customerSupport']);
    Route::post('/subscribed-email', [AdminApiController::class, 'subscribedEmail']);
    Route::post('/mobile-setup', [AdminApiController::class, 'mobileSetup']);
    Route::post('/social-media', [AdminApiController::class, 'socialMedia']);
    Route::post('/mail-setup', [AdminApiController::class, 'mailSetup']);
    Route::post('/indexslider-update', [AdminApiController::class, 'indexSliderUpdate']);
    Route::post('/indexcategory-update', [AdminApiController::class, 'indexCategoryUpdate']);
    Route::post('/indexcard1-update', [AdminApiController::class, 'indexCard1Update']);
    Route::post('/indexcard2-update', [AdminApiController::class, 'indexCard2Update']);
    Route::post('/indexcard3-update', [AdminApiController::class, 'indexCard3Update']);
    Route::post('/indexcard4-update', [AdminApiController::class, 'indexCard4Update']);
    Route::post('/indexcities-update', [AdminApiController::class, 'indexCitiesUpdate']);
    Route::post('/indexbanner-update', [AdminApiController::class, 'indexBannerUpdate']);
    Route::post('/index-sponserstore', [AdminApiController::class, 'indexSponserStore']);
    Route::post('/index-testimonials', [AdminApiController::class, 'indexTestimonialsUpdate']);
    Route::post('/index-seo', [AdminApiController::class, 'indexSeoUpdate']);
    Route::post('/index-perfectstore', [AdminApiController::class, 'indexPerfectStore']);
    Route::post('/dashboard-list', [AdminApiController::class, 'dashboardList']);
    Route::post('/add-vendor', [AdminApiController::class, 'addVendor']);
    Route::post('/view-category', [AdminApiController::class, 'viewCategory']);
    Route::post('/reporttext-list', [AdminApiController::class, 'reportTextList']);
    Route::post('/get-userview', [AdminApiController::class, 'getUserview']);
    Route::post('/get-vendorview', [AdminApiController::class, 'getVendorView']);
    Route::post('/edit-service', [AdminApiController::class, 'editService']);
    Route::post('/edit-store', [AdminApiController::class, 'editStore']);
    Route::post('/delete-review', [AdminApiController::class, 'deleteReview']);
    Route::post('/view-service', [AdminApiController::class, 'viewService']);
    Route::post('/view-store', [AdminApiController::class, 'viewStore']);
    Route::post('/unique-citylist', [AdminApiController::class, 'uniqueServiceCities']);
    Route::post('/allpayment-gateway', [AdminApiController::class, 'allPaymentGatewayKey']);
    Route::post('/update-adminprofile', [AdminApiController::class, 'updateAdminProfile']);
    Route::post('/change-adminpassword', [AdminApiController::class, 'changePassword']);
    Route::post('/update-frontedstatus', [AdminApiController::class, 'updateFrontedStatus']);
    Route::post('/update-review', [AdminApiController::class, 'updateReview']);
    Route::post('/update-slider', [AdminApiController::class, 'updateSlider']);
    Route::post('/service-reviewlist', [AdminApiController::class, 'serviceReviewList']);
    Route::post('/admin_all_login_status', [AdminApiController::class, 'admin_all_login_status']);
});



// UserAuthController
Route::post('/web-home', [UserAuthController::class, 'webHome']);
Route::post('/fetch-filterservices', [UserAuthController::class, 'filterServices']);
Route::get('category-data', [UserAuthController::class, 'getCategoryData'])->name('category-data');
Route::post('/service-count', [UserAuthController::class, 'addServiceCount']);
Route::post('/fetch-servicesubcategories', [UserAuthController::class, 'fetchServiceSubcategories']);
Route::post('/delete-storeattachment', [UserAuthController::class, 'deleteStoreAttachmnt']);
Route::post('/business-review', [VendorAuthController::class, 'businessReview']);
Route::post('/store-list', [VendorAuthController::class, 'storeList']);
Route::post('/subscription-plan', [SubScriberController::class, 'subscriptionPlan']);
Route::post('paypal-intent', [PayPalController::class, 'PayPalCheckout']);
Route::post('capture-payment', [PayPalController::class, 'capturePayment']);
Route::post('/auto-delete', [UserAuthController::class, 'AutomaticDeleteData']);
Route::get('/get-budgetcount', [VendorAuthController::class, 'getBudgetCount']);
Route::post('/get-serviceinsights', [VendorAuthController::class, 'getServiceInsights']);
Route::post('/add-newsemail', [VendorAuthController::class, 'addNewsEmail']);
Route::get('/show-pricerange', [VendorAuthController::class, 'showPriceRange']);
Route::get('/get-homeseo', [VendorAuthController::class, 'getMetaTitleDesc']);
Route::post('/stripe-subscription', [VendorAuthController::class, 'createStripeSubscription']);
Route::get('/get-category', [UserAuthController::class, 'GetCategory']);
Route::post('/get-subcategory', [UserAuthController::class, 'getSubCategory']);
Route::get('/report-text', [UserAuthController::class, 'getReportText']);
Route::post('/filter', [UserAuthController::class, 'filter']);
Route::post('/home', [UserAuthController::class, 'Home']);


Route::post('/general-settings', [AdminApiController::class, 'generalSettings']);
Route::get('/get-paymentconfig', [VendorAuthController::class, 'getPaymentConfig']);
Route::post('/get-servicedetail', [UserAuthController::class, 'getServiceDetail']);
Route::post('/get-subcategoryservices', [UserAuthController::class, 'getSubcategoriesServices']);
Route::post('/payment-configuration', [AdminApiController::class, 'paymentconfiguration']);


// Email Routes
Route::get('/showemail-emailwelcome', [WebApiController::class, 'showEmailWelcome']);
Route::get('/showemail-emailotpverify', [WebApiController::class, 'showEmailOtpVerify']);
Route::get('/showemail-emailstoreapproved', [WebApiController::class, 'showEmailStoreApproved']);
Route::get('/showemail-emailstorerejected', [WebApiController::class, 'showEmailStoreRejected']);
Route::get('/showemail-emailstorewaiting', [WebApiController::class, 'showEmailStoreWaiting']);
Route::get('/showemail-emailvendorswitch', [WebApiController::class, 'showEmailVendorSwitch']);



Route::post('addLanguageColumn', [LanguageController::class, 'addLanguageColumn']);
Route::post('translateAllKeywords', [LanguageController::class, 'translateAllKeywords']);
Route::post('updateStatus', [LanguageController::class, 'updateStatus']);
Route::post('listAllLanguages', [LanguageController::class, 'listAllLanguages']);
Route::post('getLanguageDataFromStatusId', [LanguageController::class, 'getLanguageDataFromStatusId']);
Route::post('editLanguage', [LanguageController::class, 'editLanguage']);
Route::post('fetchLanguages', [LanguageController::class, 'fetchLanguages']);
Route::post('translateoneKeywords', [LanguageController::class, 'translateoneKeywords']);
Route::post('addKey', [LanguageController::class, 'addKey']);
Route::post('fetchDefaultLanguage', [LanguageController::class, 'fetchDefaultLanguage']);
Route::post('fetchLanguageKeywordsWithTranslation', [LanguageController::class, 'fetchLanguageKeywordsWithTranslation']);
Route::post('editKeyword', [LanguageController::class, 'editKeyword']);

//Auto Mation

Route::get('/check-extensions', [UserController::class, 'checkExtensionsApi']);
Route::post('/save-configuration', [UserController::class, 'saveconfiguration']);
Route::post('/save-bucket', [UserController::class, 'savebucketconfiguration']);
Route::post('/update-bucket', [UserController::class, 'awsbucketconfiguration']);
Route::post('/validate-purchase', [UserController::class, 'validatePurchase']);
Route::post('/verified-token', [UserController::class, 'verifyToken']);
Route::post('/expire-token', [UserController::class, 'expireToken']);
// Route::post('/reconstruct-js-file', [UserController::class, 'reconstructFromBase']);
